/************************************************************ 
*    Copyright 2005-2007 fplanglois.com 
*    Poser un copyright sur ses images 
*
**************************************************************/
 
if (app.documents.length > 0) {
// Sauve l'ancienne unit et fixe le point comme nouvelle unit
sauveUnits = app.preferences.rulerUnits;

app.preferences.rulerUnits = Units.POINTS;

/************************************************************
*	Variables  Initialiser
************************************************************/
signatureText = " www.fplanglois.com";	// Votre Copyright
CoeffPolice = 0.030;   		//facteur taille de la police
SignatureADroite = true; 	//false pour une signature  gauche
SignatureEnBas = true;   	//false pour une signature en haut
LargeurDistance = 13;  		//placement  partir du bord droit ou gauche selon SignatureADroite
HauteurDistance = 0.4; 		//placement  partir du bas ou haut selon SignatureEnBas
//LargeurDistance et HauteurDistance sont fixs en fonction de la police choisie
//mais ensuite, pour une mme police, on pourra modifier le CoeffPolice de taille sans
//redfinir ces deux valeurs

//Police du copyright; attention c'est le nom
//PostScript de la police qu'il faut donner
signatureFont = "Arial-Black"; 	
//signatureFont = "Arial";       //Police alternative possible car elle est toujours installe
//alert(app.fonts[6].postScriptName);
//pour connatre le nom Poscript d'une police, activer la ligne ci-dessus, en enlevant les //
//et en remplaant le 6 par toutes les valeurs  tester
CouleurR = 0;
CouleurV = 0;
CouleurB = 0;

//Options de centrage, un peu plus compliqu  comprendre, inutile si vous ne voulez pas centrer votre copyright
SignatureCentree =false;    //true pour centrer la signature, dans ce cas la variable SignatureADroite n'est pas value. Si utilis, SignatureADroite est ignore
SignatureMilieu = false;    //true pour mettre sa signature en plein milieu (copyright destructif). Si utilis SignatureADroite,SignatureEnBas et mme SignatureCentree sont ignores
LargeurSignature =12;		
//cette variable n'est utilise que si l'on centre la signature ou pour la signature au milieu, ignore sinon. 
//Pour trouver LargeurSignature, essayer d'abord de dterminer la valeur de LargeurDistance afin de coller votre signature  droite (option SignatureAdroite active et options de centrages dsactives)
//C'est ensuite cette valeur que vous copierez dans LargeurSignature, avant de modifier ensuite LargeurDistance pour la valeur qui vous convient mieux.
HauteurSignature = 0.9;
//idem LargeurSignature, mais dans la hauteur. Utilis pour la signature au milieu, ignor sinon.
//Pour dterminer avec prcision cette valeur, trouvez la valeur de HauteurDistance qui colle votre signature en haut (option SignatureEnbas  false et options de centrages dsactives)
//C'est ensuite cette valeur que vous copierez dans HauteurSignature.
							

/************************************************************
*	Fin variables  Initialiser
************************************************************/



docLargeur = app.activeDocument.width;
docHauteur = app.activeDocument.height;
if (docLargeur/docHauteur > 1){
    //mode paysage; on prend en rfrence la largeur
    CorpsCaractere = docLargeur*CoeffPolice;
    }
else
    {//mode portrait; on prend en rfrence la hauteur
    CorpsCaractere =docHauteur*CoeffPolice;
    }


// Signature
signatureDecalageL = (CorpsCaractere*LargeurDistance);
signatureDecalageH = (CorpsCaractere*HauteurDistance);
//utilis uniquement pour les options de centrage
LargeurSignature = (CorpsCaractere*LargeurSignature);
HauteurSignature = (CorpsCaractere*HauteurSignature);




signatureCouleur = new SolidColor();
signatureCouleur.rgb.red = CouleurR;
signatureCouleur.rgb.green = CouleurV;
signatureCouleur.rgb.blue = CouleurB;



// Cration calque text
var signatureCalque = app.activeDocument.artLayers.add();
signatureCalque.name = "Signature";
signatureCalque.kind = LayerKind.TEXT;

app.activeDocument.activeLayer = app.activeDocument.layers["Signature"];

signatureCalque.textItem.contents = signatureText;


signatureCalque.textItem.font = signatureFont;

//ce paramtre est obligatoirement donn en point; c'est pourquoi on a chang l'unit au dbut du script
//en effet, ainsi, le placement de la signature restera proportionnel  la taille choisie par celle-ci
signatureCalque.textItem.size = CorpsCaractere;

signatureCalque.textItem.color = signatureCouleur;

//C'est la bonne ide de ce script :
//utiliser un style de calque prdfini dans la palette de style
//Si le programme trouve un style nomm "styleCopyright"
//(attention, respectez les majuscules et minuscules),
//il l'appliquera  votre signature
try
  {
  signatureCalque.applyStyle("styleCopyright");
  }
catch (Erreur){}

if (SignatureADroite) {
   signatureDecalageL =  docLargeur - signatureDecalageL;
   }
else
   {
   signatureDecalageL =  signatureDecalageL; //pour la lisibilit du code
   }
if (SignatureCentree) {
   signatureDecalageL =  (docLargeur - LargeurSignature)/2;	
   }
if (SignatureEnBas) {
   signatureDecalageH = docHauteur - signatureDecalageH;
   }
else {
   signatureDecalageH = signatureDecalageH; //pour la lisibilit du code
   }
if (SignatureMilieu) {
   signatureDecalageL = (docLargeur - LargeurSignature)/2;	
   signatureDecalageH = (docHauteur + HauteurSignature)/2; 
   }   

PositionTexte = new Array(signatureDecalageL, signatureDecalageH);
signatureCalque.textItem.position = PositionTexte;

// Remettre les units d'origine
app.preferences.rulerUnits = sauveUnits;
} //fin du script

else
  {//vous n'avez pas ouvert de document, le script ne peux pas fonctionner
  alert ("Ouvrez un document sous PhotoShop et relancez le script")
  }

